```
yt2doc --version
# 0.3.1

yt2doc --video https://www.youtube.com/watch\?v\=zlrb_X6fYZ0 --whisper-backend whisper_cpp --whisper-cpp-executable $HOME/Development/whisper.cpp/main --whisper-cpp-model $HOME/Development/whisper.cpp/models/ggml-large-v3-turbo.bin --sat-model sat-9l -o examples --segment-unchaptered --llm-model gemma2 --timestamp-paragraphs --ignore-chapters --add-table-of-contents --skip-cache
```

# Business Plan Writing 101: Wharton Entrepreneurship Series

https://www.youtube.com/watch?v=zlrb_X6fYZ0

### Table of contents
- [0:00:00](https://youtu.be/zlrb_X6fYZ0?t=0) [Yego: Online Marketplace Connecting Fitness & Instructors](#yego-online-marketplace-connecting-fitness-instructors)
- [0:02:24](https://youtu.be/zlrb_X6fYZ0?t=144) [Business Plan vs Pitch Deck](#business-plan-vs-pitch-deck)
- [0:03:06](https://youtu.be/zlrb_X6fYZ0?t=186) [Two-Sentence Pitch Explainer](#two-sentence-pitch-explainer)
- [0:03:36](https://youtu.be/zlrb_X6fYZ0?t=216) [Vending machine for parents on the go.](#vending-machine-for-parents-on-the-go)
- [0:04:31](https://youtu.be/zlrb_X6fYZ0?t=271) [Brainstorming Slogans](#brainstorming-slogans)
- [0:04:53](https://youtu.be/zlrb_X6fYZ0?t=293) [Treatment Database for Rare Diseases: Exploring Specific Details](#treatment-database-for-rare-diseases-exploring-specific-details)
- [0:05:50](https://youtu.be/zlrb_X6fYZ0?t=350) [Importance of Selling & Network](#importance-of-selling-network)
- [0:10:05](https://youtu.be/zlrb_X6fYZ0?t=605) [Six-Step Process for Business Success](#six-step-process-for-business-success)
- [0:15:49](https://youtu.be/zlrb_X6fYZ0?t=949) [Failed Carpet From Recycled Cards](#failed-carpet-from-recycled-cards)
- [0:16:43](https://youtu.be/zlrb_X6fYZ0?t=1003) [Brooklyn Brewery: Branding over Beer](#brooklyn-brewery-branding-over-beer)
- [0:17:18](https://youtu.be/zlrb_X6fYZ0?t=1038) [Fiverr Website Description](#fiverr-website-description)
- [0:17:59](https://youtu.be/zlrb_X6fYZ0?t=1079) [Extract Text Content](#extract-text-content)
- [0:18:07](https://youtu.be/zlrb_X6fYZ0?t=1087) [Meteor Recommends Introductions Based on Feedback](#meteor-recommends-introductions-based-on-feedback)
- [0:18:45](https://youtu.be/zlrb_X6fYZ0?t=1125) [Business Plan Pitfalls: Technical Reality vs Investor Hype](#business-plan-pitfalls-technical-reality-vs-investor-hype)
- [0:19:54](https://youtu.be/zlrb_X6fYZ0?t=1194) [Volunteer Request](#volunteer-request)
- [0:20:00](https://youtu.be/zlrb_X6fYZ0?t=1200) [Starting a Professional Services Company](#starting-a-professional-services-company)
- [0:20:09](https://youtu.be/zlrb_X6fYZ0?t=1209) [Become an expert in your industry.](#become-an-expert-in-your-industry)
- [0:20:41](https://youtu.be/zlrb_X6fYZ0?t=1241) [Professional Services: Beginner's Guide](#professional-services-beginner-s-guide)
- [0:20:55](https://youtu.be/zlrb_X6fYZ0?t=1255) [Consultancy trends: long-term contracts & big data](#consultancy-trends-long-term-contracts-big-data)
- [0:22:23](https://youtu.be/zlrb_X6fYZ0?t=1343) [Prescribing fresh food to patients with thyroid-related diseases.](#prescribing-fresh-food-to-patients-with-thyroid-related-diseases)
- [0:24:01](https://youtu.be/zlrb_X6fYZ0?t=1441) [Business Model Discussion & Planning Advice](#business-model-discussion-planning-advice)
- [0:28:34](https://youtu.be/zlrb_X6fYZ0?t=1714) [Keep it Simple - Business Roadmaps](#keep-it-simple-business-roadmaps)
- [0:30:27](https://youtu.be/zlrb_X6fYZ0?t=1827) [Warning: Avoid Exaggerating Competitors](#warning-avoid-exaggerating-competitors)
- [0:31:57](https://youtu.be/zlrb_X6fYZ0?t=1917) [Competitors Abroad, Successful in London](#competitors-abroad-successful-in-london)
- [0:32:14](https://youtu.be/zlrb_X6fYZ0?t=1934) [Business Plans & Revenue Models](#business-plans-revenue-models)
- [0:34:12](https://youtu.be/zlrb_X6fYZ0?t=2052) [Pricing Discussion](#pricing-discussion)
- [0:34:25](https://youtu.be/zlrb_X6fYZ0?t=2065) [Focus on Growth, Not Profitability (Early Stage)](#focus-on-growth-not-profitability-early-stage)
- [0:35:31](https://youtu.be/zlrb_X6fYZ0?t=2131) [Focus on Business Model, Not Financials Early Stage](#focus-on-business-model-not-financials-early-stage)
- [0:36:05](https://youtu.be/zlrb_X6fYZ0?t=2165) [Business plan length: around 20 pages](#business-plan-length-around-20-pages)
- [0:37:05](https://youtu.be/zlrb_X6fYZ0?t=2225) [Ancillary Revenue Streams: Experimentation for Success](#ancillary-revenue-streams-experimentation-for-success)
- [0:37:42](https://youtu.be/zlrb_X6fYZ0?t=2262) [Don't forget the ask: Business Plan Tips](#don-t-forget-the-ask-business-plan-tips)
- [0:40:45](https://youtu.be/zlrb_X6fYZ0?t=2445) [Start Business Planning & Early Team Building](#start-business-planning-early-team-building)
- [0:41:49](https://youtu.be/zlrb_X6fYZ0?t=2509) [Build a Team for Startup Success](#build-a-team-for-startup-success)
- [0:45:14](https://youtu.be/zlrb_X6fYZ0?t=2714) [From Idea to Action: A Founder's Guide](#from-idea-to-action-a-founder-s-guide)

## Yego: Online Marketplace Connecting Fitness & Instructors<a name="yego-online-marketplace-connecting-fitness-instructors"></a>

([0:00:00](https://youtu.be/zlrb_X6fYZ0?t=0)) Who here is actually starting a company or thinking about it? Here, there you go. Good. Okay. Good. We have some brave souls. So you have something written down somewhere. Okay. Hold on to it, keep it, because this is my original drawing from my first company, Recycle Bank. And I don't even, you know, this is 12 years ago, I guess, or whatever. 14 years ago now. And I'm sure I went on to Lyco Search or Yahoo Search. And literally typed in, how do I write a business plan? Okay. I had zero clue. No knowledge. Myself, I'm a trained attorney. I went to law school. And I came up with this idea for Recycle Bank in law school. And, you know, even when I looked around and bought some books on how to write a business plan, there was a million different ideas and concepts on how to do it. Writing a business plan is still extremely valuable. It's still the process and the rigor of going through it gets you very, very well prepared for any investor meeting or customer meeting, or potentially hiring a new employee, right? If you're potentially saying to someone, hey, take a chance with me. And, oh, by the way, I don't have a business plan. I don't have a pitch deck. I have no idea what I'm doing. Good chance they're not going to do that with you. So, some of you may debate and argue as to whether or not you should or should not have a business plan. This is Andrew Mason. It's his cocktail napkin for Groupon. Say what you will about Groupon, but it had IPO, and some people did very, very, very well. And millions of people still use it every day. So, I don't know if he wrote a business plan, but his idea was, one, thinkofthepoint.com, two, get someone to give me a bunch of money, and three, have viral exponential growth. I pray for all of you that that happens without a business plan. But for today's purposes and, honestly, for your life, if you go through the process of building a business plan, you'll be very well prepared for your company. The magic number is eight. There are eight things that need to be in a business plan. If they're not, then it's going to look incomplete, unfinished, unthought out, unprepared, and usually people can shoot pretty quick holes in them. So, what is the company? That's just the intro, pretty specific. This is something we spend a ton of time on at Dreamit, and a ton of time on we spend in my class at 8.06 and 2.31.

([0:02:15](https://youtu.be/zlrb_X6fYZ0?t=135)) MP, what is your two-sentence pitch?

([0:02:19](https://youtu.be/zlrb_X6fYZ0?t=139)) Yep, for your company. Oh, Yego is an online marketplace that matches fitness instructors and as well.

## Business Plan vs Pitch Deck<a name="business-plan-vs-pitch-deck"></a>

([0:02:24](https://youtu.be/zlrb_X6fYZ0?t=144)) Okay. So, it takes a long time to get there, to get to that point where it's condensed, it's concise. I always say it's kind of the grandpa test or the mom test, where you're trying to explain to the average person exactly what it is you do. We will run through all eight of these, but, again, these are the ones, and on the last slide, you'll see, I'll recap them again so you have them. But, these are the things you put in a business plan, not necessarily in a pitch deck, but a business plan, which is a little more of a robust, thought-out process.

([0:02:54](https://youtu.be/zlrb_X6fYZ0?t=174)) Step one, tell me about your company. Wash, rinse, repeat a million times, a trillion times. I asked MP what hers was, because she was in my class. Recycle Bank, my first company. Recycle Bank pays you to recycle.

## Two-Sentence Pitch Explainer<a name="two-sentence-pitch-explainer"></a>

([0:03:06](https://youtu.be/zlrb_X6fYZ0?t=186)) Okay. That was not our two-sentence pitch, our one-sentence pitch. And why that worked for us is if I told you we pay you to recycle, you're going to want to learn more.

([0:03:15](https://youtu.be/zlrb_X6fYZ0?t=195)) Huh. Never heard that before. I want to learn more. If you hear MP's two-sentence pitch, you understand all the contracts of how her business operates and what it is that she does. I probably said Recycle Bank pays you to recycle ten million times.

([0:03:29](https://youtu.be/zlrb_X6fYZ0?t=209)) Nanny Caddy was a company I started. It was the vending machine for parents on the go. Does that make sense?

## Vending machine for parents on the go.<a name="vending-machine-for-parents-on-the-go"></a>

([0:03:36](https://youtu.be/zlrb_X6fYZ0?t=216)) Vending machine for parents on the go. You kind of know what it is that the company does. There was a million other ways we could have spliced that sentence and added on a billion other different things, but that was what we went with, and that's what we said, you know, probably millions and millions of times to customers, employees, investors, you name it. So who here wants to try out a two-sentence pitch? Anybody have their idea, their company ready to roll? Brave souls? Come on. One more. Yes? Researching the world for safe, healthy, eco-friendly goodies and delivery tools.

([0:04:06](https://youtu.be/zlrb_X6fYZ0?t=246)) Okay. Researching the world for safe, healthy, eco-friendly goodies. Okay. All right. We'll work on that one. Who else? Anybody else? You're going to spend a lot of time on this, okay? So this is that tagline, that slogan on the front of your business plan, and I'm telling you this will, you will agonize over this more often than you think.

## Brainstorming Slogans<a name="brainstorming-slogans"></a>

([0:04:31](https://youtu.be/zlrb_X6fYZ0?t=271)) Yep. Sure. Nice and loud so we all hear it.

([0:04:36](https://youtu.be/zlrb_X6fYZ0?t=276)) Okay. Ka-ching helps you save money and turns you into a serial philanthropist.

([0:04:39](https://youtu.be/zlrb_X6fYZ0?t=279)) Okay. Helps you save money and turns you into a serial philanthropist. I don't love it. It's going to be hard for you to say that over and over again. It's got to be something that rolls off the tongue, too.

([0:04:50](https://youtu.be/zlrb_X6fYZ0?t=290)) Okay. So that is step one.

## Treatment Database for Rare Diseases: Exploring Specific Details<a name="treatment-database-for-rare-diseases-exploring-specific-details"></a>

([0:04:53](https://youtu.be/zlrb_X6fYZ0?t=293)) Yes. This is my idea for someone I'm working with. A treatment database for rare diseases. What kind of treatment database? Well, it's going to take me all longer to explain that.

([0:05:04](https://youtu.be/zlrb_X6fYZ0?t=304)) Yeah. Basically, a database where you put in what people are treated with. What type of disease? Any kind of specificity? So if they're passing these disease, but it will be for more.

([0:05:14](https://youtu.be/zlrb_X6fYZ0?t=314)) Okay. So if you start it, you just have to be safe. Okay. And say it again. A treatment database for rare diseases. Okay. So you can add a little more to that, right? Add a little more meat to the bones, because it sounds interesting. But, you know, what disease we don't know. What kind of database is it? Early-stage rare diseases, late-stage rare diseases. So there are some things you can add, some adjectives to it to give it more flavor. But, again, you're going to go over this time and time and time again. So stay with it, and that's what you're going to lead.

## Importance of Selling & Network<a name="importance-of-selling-network"></a>

([0:05:50](https://youtu.be/zlrb_X6fYZ0?t=350)) Hey, I'm about to send you my business plan for my company that does X. And that sentence is going to follow.

([0:05:54](https://youtu.be/zlrb_X6fYZ0?t=354)) Second most important thing. You're always selling.

([0:05:57](https://youtu.be/zlrb_X6fYZ0?t=357)) Okay. As an entrepreneur. If you're not a good salesperson, then find somebody who is and hire them tomorrow. The first thing you're selling is what? Yourself. Constantly, all the time. So who are you? I see a ton of business plans and a ton of pitch decks. You know, I probably see probably 50 a month. What do you think the first thing I do is? I go to the team. I try to see who these people are. What are they doing? What are they made of? And these are the things that I am looking for in their business plan.

([0:06:29](https://youtu.be/zlrb_X6fYZ0?t=389)) Okay. Do they have industry experience? I had no industry experience with Recycle Bank. I had no industry experience with Nanny Caddy. So, whoops, I'm out. But, did I have a very good team?

([0:06:41](https://youtu.be/zlrb_X6fYZ0?t=401)) Yes. I had a very unique team. We were kind of young, though. 24, 25. Not a whole lot of experience. So what did we do to buttress that? Added a really strong advisory board. These were industry experts. We had people, and I tell people in my class, find your Bob Milligan. There was a guy who joined our advisory board named Bob Milligan, who had 35 years of waste experience at Recycle Bank. He was on our advisory board. Nanny Caddy. There was somebody that actually ran a vending school to train people how to work on vending machines. I brought him on board our advisory board, because I knew nothing about vending. So if you're weak on industry experience, if you're weak on your team or you're inexperienced, bring on that advisory board. Listen, education. Where did you go to? Are you undergrad or grad?

([0:07:26](https://youtu.be/zlrb_X6fYZ0?t=446)) Yes. Grad. Where did you go to undergrad? Tufts. Anybody here? Know anybody who went to Tufts? All right. So there's always a connection, okay? Use it. Shout out from the mountaintops. It definitely helps. So don't undersell the fact that you went to a pretty good school. I even go down sometimes to high school. I ask people all the time, where'd you go to high school? Because I guarantee you, I'll probably find someone or something connected to you. Yes? I went to Germantown Academy. There we go. I went to Germantown Academy. I'm going to invest in his company automatically. Pretty simple.

([0:07:56](https://youtu.be/zlrb_X6fYZ0?t=476)) Which year did you graduate? 2011. Okay, there you go. Okay, there you go. I had, you know the guys from Brighton? Yeah, it's my best friend. Awesome. Okay, there you go. So regional. You know, play up your regional affiliations, okay? Especially if you're involved in charitable work or things like that, you need to strongly play that up. And then sports, interest, skills. Again, oftentimes, you know, I see a lot of resumes, and they're from amazing schools, very interesting people. I get down to the bottom, I say, okay, what's interesting about these people? So at the end of the night, when it's, you know, 11.45 at night, and I'm an investor, and I'm going through their business plan, is this the kind of person I want to chat with at, you know, 11.45 at night? Is this the person I want to yell at, at midnight? So you want to get that flavor from someone, especially from, you know, either the CEO, the CMO, the team, you name it. So go very, very heavy when you're building a business plan on the team, because it's what people flip to right away. All right. So this is, we're going to spend a lot of time on this. This is the bulk of any business plan, is how does it work, okay? You have to understand that if you're coming in cold to somebody with a business plan or a pitch deck, and they have no knowledge except that two-sentence pitch, and maybe you got a warm introduction because you went to Tufts, or you went to Germantown Academy, now you've got to really settle them. Like, you have the hook, right? You have that intro. Now you've got to settle them into, what is it that you do? How does this thing actually work? And there's two variations of that. There's the front end and the back end, okay? So the front end, for a vast majority of companies, is what is the customer going to see? What is it going to look like when it's out in the world? And the back end is the technology. So I found this picture. I thought it was helpful. I don't know how it was going to come up on the camera. But this is actually a famous drawing of the Metropolitan Opera. And this is what you're trying to show. The front end, which is what the audience is going to see, okay, watching this opera, and the back end, which is the million other things that go on behind it that are very, very unique, very challenging to undergo. But when it works smoothly, you put on a beautiful production of the opera, the Metropolitan Opera. So this is sort of the, in text form and visual form, the scene you're trying to paint for a potential investor.

## Six-Step Process for Business Success<a name="six-step-process-for-business-success"></a>

([0:10:05](https://youtu.be/zlrb_X6fYZ0?t=605)) Okay, so I'm going to run through some examples. Who here knows about TerraCycle? Yep? Okay. So what, a different way to do kind of that, how does it work in that user experience, is you do a, what the world looked like yesterday, and what the world's going to look like after your company's in place. So the before and after picture is very, very helpful. So you see with TerraCycle, before TerraCycle, people put their things in non-recyclable and recyclable containers. Now with TerraCycle, things are automatically reused. TerraCycle sells, I think is the number one seller of pencil cases at Target. It's all old Capri Sun juice boxes. So if that makes any sense as to how it is, what they do. But I like what they do with the before and after. And then there's a little bit of granularity. Again, the yes, yesterday and today.

([0:10:56](https://youtu.be/zlrb_X6fYZ0?t=656)) Okay. So this is one of my better companies that came out of 806. This was an Argentinian grill. Okay. Very, very simple. It got sold pretty early on, actually right after they got out of the class. When you have a physical product, who here has a physical, actual product? Nobody. All tech. That's cool. Anybody? No, I'm missing.

([0:11:19](https://youtu.be/zlrb_X6fYZ0?t=679)) Okay. I love actual physical products. This is an Argentinian grill. And really, the only focus they had was the product, the product, the product. All right. So highlighting every different aspect of this Argentinian grill from the wheelbase, from the handle, from how the cold goes in there. If you have a physical product, and I'll move along, because none of you here have them, it's, you know, you focus on that product as hard as you can.

([0:11:40](https://youtu.be/zlrb_X6fYZ0?t=700)) Okay. So a six-step process is what people want to see on the front end and the back end. I beg of you not to have a 20-step process of how your company actually works, or how your product works. If you can't explain how your company works in under six steps, then you have a too complicated process. Is anybody here building a robot to go to space? If you are, all good. Like 20 steps, I'm totally fine with that. But if you're building an app to, you know, meet red-haired girls on Thursday, probably only need, like, four or five steps on that one. And try to keep it under six. Anybody want to give it a shot here with their company? Tell me how they work. Six steps. So the first step, so it's like a social enterprise thing.

([0:12:34](https://youtu.be/zlrb_X6fYZ0?t=754)) Okay. Social enterprise. So the first step would be identify kids who are struggling in high school right now. Second step would be connect, like, run a one-on-one with them to figure out, like, their dreams and their skills. Third step would be connect them with somebody who's like a mentor who has those and that same place. Fourth step is find a location where they can maintain a two-year relationship. And then fifth step is the system with, like, getting an internship in that space. Sixth step is watching them graduate.

([0:13:13](https://youtu.be/zlrb_X6fYZ0?t=793)) Cool. Very good. Good job. All right. Harder than it seems. So when you're doing these kind of six-step processes, keep the basics out. Okay? Don't put user logs into website. All right? I see that all the time. You know, user checks out and, you know, cleans their cart, whatever it may be. Keep the basics out of there. What you're really trying to get is the meat of how your product works, not, you know, someone logs onto the computer or opens up the app. Yeah, we get it. You're an app company. I already read about that in the very, very beginning. I get that people have to open up the app to use it. So get past the simple stuff and keep it under six. So I did not follow my own advice, but 14 years later, now I know what to do, and I'm a little better at it. We had nine steps in our first one. Recycle bank lifter picks up recycling bin, reads barcode bin, register that household is recycled, records weight of recycling bin, transmits data using onboard computer, household views recycling data on Recycle Bank website. Recycle bank website translates recycling weight into, I'm already tired. I'm done. So keep it down to six, and you'll see what we ended up doing, which was a little better. Okay? Now it's a four-step process. Now people actually understand what it is that we do. So get it down to four steps. Okay? Front end and back end. So the front end is your recycle. It gets recorded, you get rewarded, and you get redeemed. One, two, three, four. I'd imagine you can get down to probably four as well. Even that first step you talked about, you could probably eliminate that at the very, very beginning. And then we also had a back end too, which was the technology behind this. So you are able to, if you don't have a step-by-step-by-step process, you can also create a narrative. If you want to tell a story, that's completely fine, and that makes a lot of sense. And I'll do some examples of that. But for the front end kind of experience, you want to do that six-step or four-step or, you know, even better two-step process if you have one. But you can see here, this was the back end technology. We didn't really get into a one, two, three, four, five, six-step process. We did, you know, told more of a story.

([0:15:19](https://youtu.be/zlrb_X6fYZ0?t=919)) Okay. So who here has had a massive failure in their life?

([0:15:27](https://youtu.be/zlrb_X6fYZ0?t=927)) Yay. I hope you all have one like I had. So this is a company that I helped run or launch called Reproduct. And we had the best, I think, four or five-step process. It still failed. So welcome to the world of entrepreneurship. And so the process was pretty simple.

([0:15:47](https://youtu.be/zlrb_X6fYZ0?t=947)) How does the process work?

## Failed Carpet From Recycled Cards<a name="failed-carpet-from-recycled-cards"></a>

([0:15:49](https://youtu.be/zlrb_X6fYZ0?t=949)) You insert the card into a two-way envelope. You address the envelope, and the envelope is mailed. Recipient receives an open card. After viewing, recipient tears off original mailing panel, inserts cards into prepaid envelope. Card recipient drops the envelope into any USPS mailbox. And then Shaw's Industries receives the card and melts it down into this type of carpet. Really simple, streamlined process. So it failed miserably because the United States Post Office, I met with the Deputy Postmaster General and told me that it would take an act of Congress for us to get a green stamp. So when the U.S. Post Office says it's going to take an act of Congress, as an entrepreneur, you know it's time to get out of there. It'll take two or three years. So anyway, so the one, two, three, four-step process, hopefully you can use these type of examples at work. So what if you're selling something you're not quite sure what the process is, and you're not necessarily selling a process?

## Brooklyn Brewery: Branding over Beer<a name="brooklyn-brewery-branding-over-beer"></a>

([0:16:43](https://youtu.be/zlrb_X6fYZ0?t=1003)) Brooklyn Brewery, I've had him in, the founders of Brooklyn Brewery, they sold Brooklyn. That was their user experience. Not necessarily the beer or how it's made. They went very, very hard that people want to buy Brooklyn. Slapped the Brooklyn logo on some things and people will buy it. And so if you look at their original business plan, it's all about Brooklyn and very, very little about beer. So it's the only one they get to here is they start talking about actual beer. So if you have screenshots, those are always good, okay?

## Fiverr Website Description<a name="fiverr-website-description"></a>

([0:17:18](https://youtu.be/zlrb_X6fYZ0?t=1038)) This is a company that came out of 806 a couple years ago. If you have screenshots, those are fantastic. If you have little doodle drawings of your pretend screenshot, those are extremely helpful as well. Just a suggestion, there's a website called Fiverr, F-I-V-E-R-R, and if that website you can go and spend $5 or $10 and you just send them like a quick drawing of a mock-up of whatever you want and they'll do it for like $5 or $10.

([0:17:46](https://youtu.be/zlrb_X6fYZ0?t=1066)) Cool. Never heard of it. I'll use that.

([0:17:49](https://youtu.be/zlrb_X6fYZ0?t=1069)) $10? Yeah, ours is like there for a wedding of $10 and they'll do iterations of it too. Perfect. It's just Fiverr with two R's. Done.

## Extract Text Content<a name="extract-text-content"></a>

([0:17:59](https://youtu.be/zlrb_X6fYZ0?t=1079)) Okay. So if you do send those screenshots though, try to highlight what the actual, what the process is.

## Meteor Recommends Introductions Based on Feedback<a name="meteor-recommends-introductions-based-on-feedback"></a>

([0:18:07](https://youtu.be/zlrb_X6fYZ0?t=1087)) So Meteor, we recommend two people to you per week. If someone recommends you meet, we will tell you who.

([0:18:13](https://youtu.be/zlrb_X6fYZ0?t=1093)) And then here's the end result of what Meteor process looks like. Very granular, very specific.

([0:18:21](https://youtu.be/zlrb_X6fYZ0?t=1101)) But anybody have questions on the user experience?

([0:18:26](https://youtu.be/zlrb_X6fYZ0?t=1106)) It is, let's say you have a 20-page business plan, which is as far out as I was trying. As far as I would stretch it, you know, this should be eight to 10 of it if you can make it that. Okay? People want to see what you've built, how you're going to build it, what the world's going to look like when you do that, what the world's going to look like after you do that. Anybody have any questions or ideas?

## Business Plan Pitfalls: Technical Reality vs Investor Hype<a name="business-plan-pitfalls-technical-reality-vs-investor-hype"></a>

([0:18:45](https://youtu.be/zlrb_X6fYZ0?t=1125)) Fiverr's a good one. What else? If the team admittedly doesn't have a CTO or doesn't have technical experience, is it forgivable that they don't know a specific back-end system to actually execute on that idea?

([0:18:56](https://youtu.be/zlrb_X6fYZ0?t=1136)) No. I had a really good company in 806 a couple years ago that was in the real estate space, crowdfunded real estate. And a great deck. People loved it, got a lot of investment interest from Atlas Ventures and First Round and some others. And everyone came back to it at the end, who's going to build this? Because in this deck, all I see is what John Investor could potentially put that money to crowdfund in. I don't see how it's going to work on the back-end. So it was a fatal flaw and really hamstrung the company.

([0:19:30](https://youtu.be/zlrb_X6fYZ0?t=1170)) Can we put assumptions in the business plan saying what we're intending to fight the Atlas for a month even though we don't have a company now tonight?

([0:19:37](https://youtu.be/zlrb_X6fYZ0?t=1177)) Yes. So we'll get to that in the roadmap, but that's very, very important. People need to get the sense that this company isn't just sitting right here. It's already being discussed with these various partners. So very, very key to do that. Anybody else?

## Volunteer Request<a name="volunteer-request"></a>

([0:19:54](https://youtu.be/zlrb_X6fYZ0?t=1194)) Okay. I need some volunteers here.

## Starting a Professional Services Company<a name="starting-a-professional-services-company"></a>

([0:20:00](https://youtu.be/zlrb_X6fYZ0?t=1200)) Do you have a company that you want to start?

([0:20:01](https://youtu.be/zlrb_X6fYZ0?t=1201)) Sure. Haystack. Anybody else? You. I do. It's professional services. Professional services.

## Become an expert in your industry.<a name="become-an-expert-in-your-industry"></a>

([0:20:09](https://youtu.be/zlrb_X6fYZ0?t=1209)) Okay. So the next part of your business plan is the marketplace, the industry.

([0:20:13](https://youtu.be/zlrb_X6fYZ0?t=1213)) Okay. You have to become an expert. It is embarrassing if you are not the expert in your industry. I used to know everything about trash. Everything. It was so exciting. You know, every company I've been involved in. So Philadelphia Distilling, I knew everything about gin. Philly Car Share, I knew everything about car rentals and the price of gas per square foot, whatever. You have to become the expert.

## Professional Services: Beginner's Guide<a name="professional-services-beginner-s-guide"></a>

([0:20:41](https://youtu.be/zlrb_X6fYZ0?t=1241)) So tell me some things about professional services that I don't know because I don't know anything about professional services. So, well, I'm actually interning for the CEO of a consulting firm.

([0:20:50](https://youtu.be/zlrb_X6fYZ0?t=1250)) Okay. In the summer. So hopefully I'll know more. Go ahead.

## Consultancy trends: long-term contracts & big data<a name="consultancy-trends-long-term-contracts-big-data"></a>

([0:20:55](https://youtu.be/zlrb_X6fYZ0?t=1255)) So consulting is usually done on billable hours, but the revolutionary trend right now, as you're seeing that completely go away, and a lot of the big firms are looking potentially longer term contracts. The other trend is that they're moving towards big data. So basically everything's becoming a lot more technological and also a lot more long term. So if you are doing a project that has a lot of tech that your client can't understand, instead of leaving them after a couple of months, now they need you to stay on. Okay, you'll get there at the end of the summer. The trick here is you have to assume that whoever's reading this business plan has no knowledge of industry. So don't make them do the homework to get a sense of, okay, professional services, I don't really know much about that. This is your chance to gather that person and say, I'm going to tell you everything I know about professional services. I see a lot of pitch decks about e-commerce, okay, and people start talking about the history of e-commerce. That's not what I'm talking about, all right? We all know we can shop online and mobile trends are going up, et cetera. But if you're doing e-commerce for skirts, you should know everything about skirts and tell me every possible thing that I need to know about it so that I can make an informed investment decision. I don't necessarily need to know everything about e-commerce, I need to know everything about skirts.

## Prescribing fresh food to patients with thyroid-related diseases.<a name="prescribing-fresh-food-to-patients-with-thyroid-related-diseases"></a>

([0:22:23](https://youtu.be/zlrb_X6fYZ0?t=1343)) By chance, anybody working on a skirt company? No, okay. Who else is starting a company and is an expert or will be an expert? Yes? I'm working on, I'm already working on something that prescribes through local health centers fresh food for patients with thyroid-related disease. What type of disease? Thyroid-related disease, so high cholesterol, high blood pressure, heart disease.

([0:22:45](https://youtu.be/zlrb_X6fYZ0?t=1365)) Okay, how many people are there? Right now we're working with 12 patients. No, how many people in the world, in the U.S. have these types of diseases? I'd say one in four people have diabetes in the U.S., and heart disease is the major killer of women in the U.S. Okay, awesome. These are the kind of facts and information that this, during this section, is, I mean, this should be the softball for you, right, when you're writing a business plan. It's like, oh, recycling? I got this. I know everything about it. Professional services? Got it. I'm going to just throw the kitchen sink at them. Whatever, you know, all the information you sent me right there is perfect, and more and more and more and more. So, this is your softball section. You should easily kill that one. All right, so the roadmap, okay? So, getting an understanding of, okay, you're raising a million dollars to build your business. Where does that get you? Okay, what are the plans that you're going to put in place? How are you going to get the cart from here to there? That is the fatal flaw in all business plans and all pitch decks. I'm going to build it, and everybody's going to come. No, that's not what's going to happen. You're going to build it, and nobody's going to come. So, how are you going to get people to come to your site? How are you going to get people to use your service? You have to have a plan. You have to have it written. You can't just say it's going to go viral like Groupon did. You have to figure out the plan that makes a whole lot of sense.

## Business Model Discussion & Planning Advice<a name="business-model-discussion-planning-advice"></a>

([0:24:01](https://youtu.be/zlrb_X6fYZ0?t=1441)) So, this is for Nanny Caddy. It was pretty simple. These are the places we needed to go, and for us, it was really hardcore sales. We are going to hire our salespeople to go talk to Disney. We are going to hire our salespeople to go talk to, you know, Universal Orlando and the various airports. Your company. If I gave you a million dollars, what is the first thing you would do? If you gave me a million, first thing I would do would be, like, identify one major, so I would take Philly for schools, and then I would go in, like, source schools that had a graduation rate that was below average within their, like, within the region. So, it's really, like, what schools have, the graduation rate below the average for kids here. Okay. And then... That would take you one hour. Yeah, exactly. Okay. And no money. Yes. And then, at that point, I would build, I'd pay someone to build an interface that would identify or source mentors, basically, ask them what their dreams were, what their skill sets were, and then do the same thing for a student-facing thing and do a match. Okay. So, another basic, another point about this is to keep out the basics when you're building your roadmap. If someone says, I'm going to invest in your company, don't say, well, I'm going to go set up an LLC, and then I'm going to get incorporated, and I'm going to hire an attorney. No, no, no. What are you going to do that's going to build this company? Do you have some sort of guerrilla marketing tactic? Do you have some sort of strategy to get in front of the Fortune 500? Do you have some sort of partnership that you're kind of in conversation with, or you're, maybe you're BSing a little bit that you've had the conversation with these people, but here's the people you want to speak with. Here's the emails you've sent to certain people, and I've seen business plans that are very, very effective, where they actually show me a list of all the people, all the customers they've spoken to already, before they even started the company, what the response was on the email, what the email address was, when it was sent. This gives people the sense that the train is left. It's leaving the station. It's gone. It's time for you to get involved as an investor or as an employee or as a potential customer. So really, really spend a lot of time figuring out over the next 18 months what it is that my company is going to do. What are the milestones I'm going to hit that will make this company a success? And you're painting a picture of the future, right?

([0:26:18](https://youtu.be/zlrb_X6fYZ0?t=1578)) If you remember what we talked about with TerraCycle, before TerraCycle and afterwards, before your company and afterwards. 18 months from now, what is it going to look like? Two years of what it's going to look like. The only thing I would caution you on that is some people say, well, you know, in 10 years we're going to have an IPO. Okay? You don't want to make bold predictions that if it don't happen, you're kind of screwed and people can call you on that. But you want to make bold predictions for where you think the company will be in terms of number of customers, number of inflection points, number of cities you've partnered with, number of brands you've worked with, number of downloads, you name it. Those are the kind of things you want to be focusing on.

([0:26:55](https://youtu.be/zlrb_X6fYZ0?t=1615)) Really, anybody, yes?

([0:26:58](https://youtu.be/zlrb_X6fYZ0?t=1618)) Question about TerraCycle. I knew that initially as doing worm fertilizer in reused pot bottles. Yep. I knew that they're running stuff in like pencil cases in Target. That's a huge difference in business models.

([0:27:12](https://youtu.be/zlrb_X6fYZ0?t=1632)) Sure. So, were they pitching this Target thing or were they pitching, you know, that's... No, no. So, yeah, TerraCycle's been around for about 10 years now and their first business plan was all about worm poop. So, it was a good business plan because they got people to invest, I think, 1.5 in the very beginning because they had a very unique business plan to source the worm poop. And they already had a contract with, I think, Walmart and turned it into fertilizer. So, very good book, by the way. I can't remember the name of his book, but it's a really good book on writing the initial business plan.

([0:27:42](https://youtu.be/zlrb_X6fYZ0?t=1662)) And so, in his last 18 months, was Target even on the right side?

([0:27:45](https://youtu.be/zlrb_X6fYZ0?t=1665)) No, no. You want to be careful here, and that's a very good question. You want to be careful about thinking about all the different ancillary things that you could do. You can imagine with Recycle Bank, at the very beginning, there's a million different ways we could save the world. But we were very focused on 18 to 24 months, what our roadmap was, what are the different things that we could handle. Not necessarily, oh, in 10 years, we're going to have this e-waste collection service. And those are things we could have added on, but it would be very, very focused on the roadmap. But he certainly didn't talk about, you know, Target and things like that.

([0:28:12](https://youtu.be/zlrb_X6fYZ0?t=1692)) Yep. On the note of emails, do you use some sort of validity or would surveys fit into that category?

([0:28:19](https://youtu.be/zlrb_X6fYZ0?t=1699)) Surveys are good, but they have to cross a certain threshold.

([0:28:22](https://youtu.be/zlrb_X6fYZ0?t=1702)) What's that? Landing pages.

([0:28:24](https://youtu.be/zlrb_X6fYZ0?t=1704)) Yes. Yeah. I mean, you've got to get above 100, you know, 150. There was a company that came out of 806, I think.

## Keep it Simple - Business Roadmaps<a name="keep-it-simple-business-roadmaps"></a>

([0:28:34](https://youtu.be/zlrb_X6fYZ0?t=1714)) Yeah, Charge It Spot, which I'm sure you guys have seen around campus here. And in his business plan, he had the survey results from standing on the corner of 36 and Walnut, talking about people and their battery life and what a frustration it was. And in that business plan, it was just, these are the comments people had. And I was like, okay, interesting. You know, I'm into it. Outdated movie maybe, but Philadelphia, Denzel Washington, Tom Hanks. Keep it simple. Explain it to me like I'm a two-year-old. Okay, is what Denzel says in the movie when I'm telling you now. Keep it simple as to your roadmap. I want to know if this happens, then Y is going to happen, then Z is going to happen. We're going to start over again, A, B, C, D. And these are the different milestones we're going to hit along the way. If you make it seem like it's impossible, I'm not going to invest. I'm going to read your business plan and say, like, God bless. I'm not doing this. This is way too hard. But keep it simple. Keep it optimistic. Okay, competition. It's time to freak out. Oh, my God, we've got competitors. You need to embrace this, okay? This is just a general point about competition in general. I freak out all the time about competition for the companies I work with at Dreamit and Wharton. Like, oh, it's over. Forget it. It's a competitor in the market space. Don't do it. But, you know, acknowledge it and move on. And especially in your business plan, if you say we have no competitors, then that means no one has ever thought this was an interesting enough idea to put any investment dollars in, and it has no traction. Be very, very careful. Somebody in this room may have an idea that nobody's ever thought of, and that would be awesome. But it's very, very, very, very rare. So try to find competitors, even if there's ones that are loosely connected. And you'll see an example I have for Nanny Caddy that maybe will help. This is a bad example of a competition section of a business plan. The company we're talking about was right here, and this was their competition.

## Warning: Avoid Exaggerating Competitors<a name="warning-avoid-exaggerating-competitors"></a>

([0:30:27](https://youtu.be/zlrb_X6fYZ0?t=1827)) Okay, so yes, I am totally freaked out. I do not want to invest in this company because it looks like everyone else in the world exists. I'm sure this person was a consultant at some point. I'm sure you all have done this in your consultant world, those who are grads here. So just be really careful. Don't freak people out and say there's, you know, 90 competitors. At most in your business plan, four to five competitors. Okay? Highlight what their strengths are. Highlight what their weaknesses are. But four to five competitors at most. Not, you know, whatever, 30 or 40 or 50. This is a good example. This is a company that was doing a quick service restaurant in Kenya. You know, six competitors. Or what is that? Yeah, six competitors. A couple facts about them, how they're doing, how they're growing, how they're expanding. Nice narrative. Okay, this is a healthy space. This isn't a brand new space no one's ever thought of. For Nanny Caddy, there weren't many competitors, to be honest. So I had to kind of extrapolate and think about what is the potential competition. So I included Koala Care. Koala Care are the changing tables that are in every bathroom, in every restaurant around the world. They do not have a vending machine for parents on the go. But if I'm being smart about it, I've got to realize that they could be a competitor. So I had to add them in there. So if you're struggling, like, you know, there's no competitors, there's only one competitor, try to find people that you think potentially maybe could acquire you. Because they are, you know, a competitor.

## Competitors Abroad, Successful in London<a name="competitors-abroad-successful-in-london"></a>

([0:31:57](https://youtu.be/zlrb_X6fYZ0?t=1917)) Any question on competition? No? Yes? So I see you have the text in California. So if our main competitors are abroad, so the idea has been done successfully, but in London, I'd say so.

## Business Plans & Revenue Models<a name="business-plans-revenue-models"></a>

([0:32:14](https://youtu.be/zlrb_X6fYZ0?t=1934)) Yep. Do you emphasize that on purpose? Just sort of say, I'm doing this somewhere else? Yeah, it's absolutely fine. Another thing is, if you have a competitor that failed, right, explain that. Explore it. Because I want to see why they failed as an investor, if I'm reading your business plan. I want to get a sense of, oh, someone's tried this before. Here's why they failed. For example, one of these companies, I forget which one, they did a franchise model. And it flamed out very, very quickly. But it was a good example for investors to say, okay, Nanny Caddy's not doing the franchise model. But this other company did, so we understand, you know, potential strategies. So if you are going to do a competitive chart, stay away from things like this. This company was called 95E, and apparently they're better than Google already. And they haven't even started. So be careful with these charts and add some context as well. So, you know, yes, this company's not better than Google. They just got started. So don't over-inflate your ego too much when you're doing competition. So revenue is cost drivers. I know this is counterintuitive at Wharton, but for the goals of, you know, certain members of the investment community, they're not looking for your pro forma right now. Okay? The biggest things that people like to look for in a business plan, how are you going to make money, and what are your costs? That's it. So can someone tell me how they're going to make money with their company? You in the corner? Take equity with the people that have cut out my clients. You're going to take equity into their companies and hope that they end up having the exit or dividend share or something like that. And what are your costs? Still trying to figure out that part. It's part of the road now.

([0:33:55](https://youtu.be/zlrb_X6fYZ0?t=2035)) Okay. All right. Who else here knows how they're going to make money? You, in the pink, sir. How are you going to make money? In my made-up business, I will charge students a fee for trying.

## Pricing Discussion<a name="pricing-discussion"></a>

([0:34:12](https://youtu.be/zlrb_X6fYZ0?t=2052)) Okay. You know what that charge is? That will be, I don't know, $50. And what are your costs? Development, marketing, and staff.

## Focus on Growth, Not Profitability (Early Stage)<a name="focus-on-growth-not-profitability-early-stage"></a>

([0:34:25](https://youtu.be/zlrb_X6fYZ0?t=2065)) Okay. That's, I mean, look, it gets a little bit, you know, you can get a little bit granular, but you've got to be careful here as well as predicting the future to say, like I mentioned before, having an IPO or becoming profitable. Okay? It's not, at this stage of the game, what you care about or what investors care about. They're not necessarily thinking, oh, I can't wait until this company becomes cash flow positive. They're looking for how you're going to grow, how you're going to build your company to that next inflection point in the roadmap that we talked about earlier. Again, this is not necessarily something that people are looking for in the business plan. It may be for the purposes of maybe the business plan competition, baking out your financials, and that makes sense. But for the general pitch deck or general business plan, when you're getting in front of an investor, a year five financials, that's kind of the second conversation you have. Okay? The first conversation is, here's my amazing idea. Here's why I'm an awesome team. Here's how this thing works. I'm an expert in the industry. Here's some competitors. Here's how we make money. Here are our costs. But we're not getting into what you're paying for rent year five. So here's a really horrible example of that.

## Focus on Business Model, Not Financials Early Stage<a name="focus-on-business-model-not-financials-early-stage"></a>

([0:35:31](https://youtu.be/zlrb_X6fYZ0?t=2131)) First of all, this is a 53-page business plan. 12 pages on the actual financials. That's not where we are in this stage of the game. When you're raising your Series A or Series B or doing an IPO, hell yeah. You have to have that stuff. But right now, you don't know. There's no, and none of you raised your hand, or I actually forced two people to raise their hand on how they're going to make money. So predicting the future on that is very, very challenging. This is what we thought we were going to do for Recycle Bank, and this is enough for us to raise a couple million dollars, was here are our cost drivers and here are our revenue drivers. Here's what we think.

## Business plan length: around 20 pages<a name="business-plan-length-around-20-pages"></a>

([0:36:05](https://youtu.be/zlrb_X6fYZ0?t=2165)) Yes? What is a reasonable length for a business plan? I don't know what the length is for the business plan competition. Is there a requirement or cap? Under 25. Under 25, yeah. So 20 pages, right, is generally where I would be. But if you look, by the way, none of this turned out to be true, how Recycle Bank made money. Okay? But this is what we thought. This is what we thought our revenues would be, and this is what we thought our costs would be. And if you have no, you know, understanding of financials, if you want to tell a story about how you're going to make money and a narrative, that can actually work well. Again, this is not the meat and potatoes of your business plan. People are not rushing to see what your financials are. I told you the first thing people do is they go to the team. Okay, check. Seems like a pretty cool team. They go to the how it works. They go to the competition. They want maybe a little bit of the industry. And then maybe they'll get into this. But they're not going to spend a whole lot of time there.

## Ancillary Revenue Streams: Experimentation for Success<a name="ancillary-revenue-streams-experimentation-for-success"></a>

([0:37:05](https://youtu.be/zlrb_X6fYZ0?t=2225)) All right, so this is what we did for Nanty Caddy. Physical product, very, very simple. If you have ancillary revenue streams that you think may happen, this is where you can kind of experiment. We know what our core revenue streams are going to be, and everybody's going to put, what's the number one ancillary revenue stream? Advertising. All right? So, sure, put that in there. You know, we experimented, and this actually became true. We put embedded sales pieces. We did diapers.com. We had a partnership with them. We sponsored different coils. We sponsored different rows. But, you know, clearly we had our core, which was the actual selling of diapers, and we layered on ancillary revenue streams.

## Don't forget the ask: Business Plan Tips<a name="don-t-forget-the-ask-business-plan-tips"></a>

([0:37:42](https://youtu.be/zlrb_X6fYZ0?t=2262)) Any questions on financials? I'm not the guy to talk to. All right? I am the guy to talk to if you want to tell me how you're going to make money and what your costs are. But, you know, your costs for your health insurance, I have no idea. Why did I read the business plan? Why did I spend, you know, 10 minutes hoping through your business plan? Please, at the very, very, very end, you've got to have an ask. I spend a lot of time looking at business plans, and at the end, it's like, what? There's no ask? Nothing? You're just telling me some sort of vision of the future? More often than not, you're looking to raise capital, right, when you have a business plan. We need X amount of money to do those things that I talked about in the roadmap, to fund these, that user experience, to fight off that competition. And here's where you ask for it. It's very, very simple, very, very basic. This is what we used for Recycle Bank. It was not good at all. I don't even know how much money we were looking to raise, because it says $150,000, $800,000, $1.1 million. Very, very confusing. Be very, very clear. I'm raising $400,000 for the next 18 months of my company's life. We are looking to achieve these three or four things that I reference in the roadmap. Do not promise in the ask that if you give me $400,000, I'm going to return 3x in 2018 at a preferred rate of, you know, 4.7%. All right? Legally, that's also a big problem, because you're going to get caught on that, because it's probably not going to happen. But no investor is going to buy it. Yep? How educated should you be? Well, I think that's a bad question. But what if you have no idea what this investor is able to invest? So should there be a conversation before so you know exactly which ranks they're in? No. If they're only going to give you $100,000, or if they're only looking to give $100,000, but you need $400,000, you don't have a plan for it. It's a good question, and I ran into that trap probably with this company, with Nanny Caddy. It was customizing my business plan for every investor. All right? So the answer is no. Do not customize. You tell them, look, I'm raising, in this example, we're raising $600,000 for kind of a generic understanding of the things we're going to do and the different costs we're going to do. And on the phone, you tell them or in person, we're taking pockets of $25,000 and up. And if you're $100,000, that's great. If you're $25,000, that's great too. If you're $300,000, even better. But you give them the general picture so it's not customizable because it's very, very challenging to send out customizable business plans to a million different people. Open for questions here. It is a magic number of eight. Try to keep these sorts of high-level parameters when you're thinking about your business plan. Now listen, this is going to change constantly, I mean daily. If you look at half the slides up here for any company I've been involved in, it changed a month later. But the rigor of going through, making sure I'm an expert, making sure I know the competition, that's the worst as well.

([0:40:35](https://youtu.be/zlrb_X6fYZ0?t=2435)) is if I call an investor with a business plan and they show me a competitor that I've never seen, you know, that's kind of embarrassing. So you do that rigor to help you prevent against all those things.

## Start Business Planning & Early Team Building<a name="start-business-planning-early-team-building"></a>

([0:40:45](https://youtu.be/zlrb_X6fYZ0?t=2445)) Yes. So when does a startup actually need a business plan and when should a startup worry about hiring, you know, these people, sales, marketing, like you mentioned before?

([0:40:55](https://youtu.be/zlrb_X6fYZ0?t=2455)) Sure. So I would argue that you should start working on a business plan now because it actually forces you to make it real. Otherwise, you're just hacking away, you're building code, you're thinking about dreams or whatnot and thinking about how you're going to make money, but you're not actually taking the time to sit down and say, I'm going to figure out what the competitive landscape looks like, what it is I want to achieve in the roadmap. who are the people I want on my advisory board? Maybe you don't have them today, but if you bake out, here's my team and here's who I'd like, then that's going to force you to go and get those people to be a part of your advisory board. So I would argue you should start today. In terms of hiring, I mean, it's best to have a team around you as early as possible. The question that most startups have is how you're supposed to pay them. And probably the only thing you can do right now is with equity and options.

## Build a Team for Startup Success<a name="build-a-team-for-startup-success"></a>

([0:41:49](https://youtu.be/zlrb_X6fYZ0?t=2509)) Well, I heard that when I was listening to an editor that you should be able to hire people concentrating on the product first.

([0:41:57](https://youtu.be/zlrb_X6fYZ0?t=2517)) Sure. Well, I mean, this guy right here, he doesn't have any tech talent, right? So it's going to be, maybe you do, maybe you don't, I don't know. At the end of the day, you've got to bring the team around you to help you build your product. If you're a one-man show, it's very rare to find those one-man show companies that are very successful.

([0:42:15](https://youtu.be/zlrb_X6fYZ0?t=2535)) You mean, like, besides the co-product?

([0:42:17](https://youtu.be/zlrb_X6fYZ0?t=2537)) Yes. I mean, look, the general rule of thumb is to hire slow and fire fast in life and in startups. You don't necessarily have to hire people. You can bring them on board with options so they're not actually taking equity in the company until it's invested, you know, a year out or two years out. But yet, you have to build a team around you. I spent two years thinking I could build a recycle bank by myself. And that was a waste of two years because I couldn't. I had no knowledge of anything. So thankfully, I was able to surround myself with a team. All right. Who else? Questions? Yes. I think I was going to ask you to do a lot of things. I was going to ask you to do a lot of things. Yep. How is the law that's related to the products?

([0:43:00](https://youtu.be/zlrb_X6fYZ0?t=2580)) Yep. There's P-Mall. There's Taobao. Yep. And there is a vertical, like that's an imported supplement for fresh fruits and vegetables. Where should I? Those are what you call industry competitors. They're not actually specific competitors. They don't do exactly what you do, but they're in your space. They're in your industry, kind of, right? They kind of touch what you do. And those are the ones you should highlight because it wouldn't take long, potentially, for one of those companies to, and it probably would because they're a big company, but in their mind, to just put some capital behind it and do what it is that you do, right? So for Recycle Bank, nobody else was doing what we're doing, but Waste Management is a billion-dollar publicly traded company. We should consider them competitors, and they ultimately did end up investing, but there wasn't anybody doing exactly what we do, but we included them as potential competitors. And if you do consider size, should I include Amazon more? I mean, Amazon's not considering you, right? But you should consider them. I think I saw somebody over here. Yes? If you are requesting for financing from investors, do you specify the terms of distribution? No. So in a business plan, do not get into the terms of the deal, okay? Because you're going to throw a lot of people off, and what you're really trying to do is get them excited and get them interested in it. If I saw your business plan, you said I'm raising, you know, 500K, and my valuation's 10 million, and that's it, well, I'm probably going to just not look at your business plan because I think it's way off base. But it may be over the phone call or maybe over the next follow-up meetings you're able to convince me of that. That's fine. But just putting it hard and fast in that document is a very challenging hurdle to get over because you're going to throw off a large portion of the market. But I guess in the future, if you do consider an agreement, that the distribution has to be written in the contract? Well, that's more of a legal conversation about the operating agreement amongst the shareholders than anything else. But again, the business plan, you really shouldn't get into the specifics of if you give me 200K, I'll give you 20% of my company because that's all in the negotiation of the actual deal.

## From Idea to Action: A Founder's Guide<a name="from-idea-to-action-a-founder-s-guide"></a>

([0:45:14](https://youtu.be/zlrb_X6fYZ0?t=2714)) So you're a serial entrepreneur, and it seems like you think of a lot of different ideas and companies. What about a particular idea makes you know that it's worth pursuing versus another? So, like, how do you go from ideation to what you actually want to work on? And then secondly, what do you look for people that you pull around with first? I used to do this to my detriment. It was, and I think you probably all heard this term already, is the me test or you test it against yourself. I think this is a great idea. My family thinks it's a great idea, so I'm going to go do it. That's not good. The best way to do it is the we test, right? Is you go out into the world, and that's when you know whether or not you have something. So for Nanny Caddy, I went out and I saw what one looked like, and then I went back and I called Sesame Place and SeaWorld Orlando and Philadelphia Airport, and I got callbacks within 24 hours saying, great, can you get us two or three? And that customer validation, I think people are fearful of it because they feel like if I tell somebody my idea, they're going to take it. They have a million other things to do. They're probably not going to. So get that customer validation, and that will, I think, is the smartest way to start a company. And the second thing, in terms of the team, what can't you do? Right? You've got to figure out what you can't do. And sure, as the CEO of any company or any startup, you're doing everything, taking out the trash, legal, finance, marketing, you name it. But if there are people that can do something better than you, then bring them on board. Yes?

([0:46:44](https://youtu.be/zlrb_X6fYZ0?t=2804)) You mentioned that the roadmap would be the best place to put the hypotheses that we have in the future since that's what we're going to be doing in the future. We'll be verifying those. Is that true, even if the hypotheses relate to operational elements or revenue streams?

([0:47:00](https://youtu.be/zlrb_X6fYZ0?t=2820)) Not much. Well, revenue streams, you have to have your core revenue stream clearly defined. Right? Everything else is a guess. All right?

([0:47:11](https://youtu.be/zlrb_X6fYZ0?t=2831)) So what is your core revenue stream? How do you plan on make money? Everything else is kind of just gravy on top of that. If it's advertising, if it's sponsorships, if it's referral fees, you know, the equity that you have turns into, you can sell it on second market or, you know, the secondary markets. That's all gravy and you hope it exists. But have it in your roadmap and everywhere else. Core revenue streams very clearly defined.

([0:47:34](https://youtu.be/zlrb_X6fYZ0?t=2854)) Yeah, please. Is this the eight items they outlined here? Is this optimized for written business plans or slide decks or... Both. Everything, yeah. And look, if you get really, really good at this, like it takes... At Dreamit, we spend about two weeks, I'm not kidding, on the two-sentence pitch because it's just, there's just a mess right now and they try to solve the world or save the world and there's a million other things. If you get really good at this, you can do all eight things in like four sentences. And that is when you know you've got it because if you can handle the competition, the financials, your team, marketplace, that's when you know that you've done a business plan because you spent that time. And that's when you know that you've got it. And that's when you think about it. And that's when you think about it. And that's when you think about it. And that's when you think about it. And that's when you think about it.